﻿using Microsoft.Web.Http;
using PpmsDataService.V1.Mappers;
using PpmsDataService.VA.PPMS.Context;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Threading.Tasks;
using System.Web;
using System.Web.Http;
using System.Web.OData;
using System.Web.OData.Routing;
using VA.PPMS.Context;

namespace PpmsDataService.V1.Controllers
{
    [EnableQuery]
    //[Authorize]
    [ApiVersion("1.0")]
    public class SpecialtiesController : ODataController
    {
        [ODataRoute("Specialties('{key}')")]
        public async Task<HttpResponseMessage> Get([FromODataUri] string key)
        {
            //We will use the Query type found in URL to determine if Expanded properties need to be mapped. 
            var queryType = HttpContext.Current.Request.Url.Query;

            //This Scenario matches a Specialty on its specialty code.  
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {                
                //Retrieve the Specialty Record
                var ppmsSpecialty = context.ppms_taxonomySet.FirstOrDefault(i => i.ppms_SpecialtyCode.Equals(key));
                if (ppmsSpecialty != null)
                {
                    var ppmsSpecialtiesList = new List<ppms_taxonomy> { ppmsSpecialty };
                    var specialty = await SpecialtyMap.MapSpecialties(ppmsSpecialtiesList, queryType, context);
                    return Request.CreateResponse(specialty);
                    //return Request.CreateResponse(SingleResult.Create(specialty));
                }
            }
            var message = string.Format("Specialty with Specialty Code: {0} not found", key);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
        }

        [ODataRoute("Specialties('{key}')/ProviderSpecialties")]
        public async Task<HttpResponseMessage> GetProviderSpecialties([FromODataUri] string key)
        {
            //This Scenario matches a Specialty on its specialty code. 
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Retrieve the Specialty Record
                var ppmsSpecialty = context.ppms_taxonomySet.FirstOrDefault(i => i.ppms_SpecialtyCode.Equals(key));
                if (ppmsSpecialty != null)
                {
                    //Return the related Provider Specialties
                    var ppmsProviderSpecialties =
                        context.ppms_providertaxonomySet.Where(i => i.ppms_TaxonomyId.Id == ppmsSpecialty.Id);
                    var ppmsProviderSpecialtiesList = ppmsProviderSpecialties.ToList();
                    var providerSpecialties =
                        await ProviderSpecialtyMap.MapProviderSpecialties(ppmsProviderSpecialtiesList, "None", context);
                    return Request.CreateResponse (providerSpecialties);
                }
            }
            var message = string.Format("Provider Specialty with Specialty Code: {0} not found", key);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
        }

        [ODataRoute("Specialties('{key}')/ProviderServices")]
        public async Task<HttpResponseMessage> GetProviderServices([FromODataUri] string key)
        {
            //This Scenario matches a Specialty on its specialty code. 
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Retrieve the Specialty Record
                var ppmsSpecialty = context.ppms_taxonomySet.FirstOrDefault(i => i.ppms_SpecialtyCode.Equals(key));
                if (ppmsSpecialty != null)
                {
                    //Return the related Provider Services
                    var ppmsProviderServices =
                        context.ppms_providerserviceSet.Where(i => i.ppms_specialty.Id == ppmsSpecialty.Id);
                    var ppmsProviderServicesList = ppmsProviderServices.ToList();
                    var providerServices =
                        await ProviderServicesMap.MapProviderServices(ppmsProviderServicesList, "None", context);
                    return Request.CreateResponse(providerServices);
                }
            }
            var message = string.Format("Provider Services with Specialty Code: {0} not found", key);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
        }

        [ODataRoute("Specialties")]
        public async Task<HttpResponseMessage> Get()
        {
            //This Scenario returns the first 50 Providers in the system. . 
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsSpecialties = context.ppms_taxonomySet.Where(i => i.ppms_SpecialtyCode != null);
                var ppmsSpecialtiesList = ppmsSpecialties.ToList();
                if (ppmsSpecialtiesList.Any())
                {
                    //Map Providers
                    var specialties = await SpecialtyMap.MapSpecialties(ppmsSpecialtiesList, "None", context);
                    return Request.CreateResponse(specialties);
                }
                var message = "Specialties Not Found";
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
            }
        }
    }
}